<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0 text-dark">Notices</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                        <li class="breadcrumb-item active">Notices</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Notice List</h3>
                        </div>
                        <div class="card-body">
                            <?php if(Auth::user()->role === 'admin'): ?>
                            <a href="<?php echo e(route('notices.create')); ?>" class="btn btn-primary">Create Notice</a>
                            <?php endif; ?> 
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Title</th>
                                        <th>Created At</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $notices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($notice->title); ?></td>
                                        <td><?php echo e($notice->created_at); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('notices.show', $notice->id)); ?>" class="btn btn-info">View</a>
                                            <?php if(Auth::user()->role === 'admin'): ?>
                                                <a href="<?php echo e(route('notices.edit', $notice->id)); ?>" class="btn btn-warning">Edit</a>

                                                <form action="<?php echo e(route('notices.destroy', $notice->id)); ?>" method="POST" style="display: inline;">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this notice?')">Delete</button>
                                                </form>
                                            <?php endif; ?>                                       
                                    </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                            <?php echo e($notices->links()); ?> 
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fiveium/public_html/sub-domains/license.fiveium.com/application/resources/views/notices/index.blade.php ENDPATH**/ ?>